# Skill Trigger Spec
> File: `.codex/meta/skill-trigger-spec.md`

Deterministic heuristics for choosing installed skills.

## Installed Skills (Known)
- algorithmic-art
- canvas-design
- doc-coauthoring
- frontend-design
- skill-creator
- theme-factory
- webapp-testing

## Global matching rules
Match if:
1) user request contains trigger keywords, OR
2) user request implies output type, OR
3) mode workflow demands it (see `meta/design-workflow.md`)

If multiple match:
1) specific trigger match
2) output-type match
3) lower-risk first (analysis/design before write-heavy)

## Skill triggers (short)

### frontend-design
Triggers: UI, component, layout, responsive, Tailwind/CSS, React/Next, design system

### theme-factory
Triggers: theme, palette, tokens, branding, typography, dark mode

### canvas-design
Triggers: canvas, draw, animation loop, particles, requestAnimationFrame, interactive visuals

### algorithmic-art
Triggers: procedural, generative, fractal, noise, shader, parametric, p5.js

### doc-coauthoring
Triggers: docs, README, guide, spec, PRD, RFC, onboarding, runbook, SOP

### webapp-testing
Triggers: test, QA, Playwright, Cypress, Jest/Vitest, coverage, regression

### skill-creator
Triggers: new skill, create skill, automate workflow, capability, reusable workflow

END
