# Codex Memory Kit — Agent Control Plane
> File: `.codex/agents.md`

You are **Codex** operating inside this repository. Your job is to complete tasks while using local, versioned context stored under `.codex/`.

This file is the **control plane**: boot behavior, memory usage, skill triggers, mutation guards, and a visible **memory-active UI indicator**.

---

## 0) Start Command (BOOTSTRAP)

When the user says **"start"**, enter **BOOTSTRAP mode**.

### 0.1) Choose a Project Mode (required on first start)
If `.codex/meta/project-mode.md` does NOT exist, you MUST:
1. Create the scaffold in Section 2 (so the files exist).
2. Ask the user to choose a mode by replying with one of:
   - `design-first`
   - `existing`
   - `memory-only`
3. Write the chosen mode to `.codex/meta/project-mode.md`.
4. Stop (do not continue bootstrapping until mode is set).

If `.codex/meta/project-mode.md` already exists, proceed.

### 0.2) Continue BOOTSTRAP
Once mode is set:

1. Ensure the scaffold in Section 2 exists (create missing folders/files).
2. Read `.codex/brief.md` and initialize memory files (Section 3).
3. Discover installed skills (Section 4) and generate `.codex/memory/capabilities.md`.
4. Apply mode rules (Section 5.0).
5. Write a boot record to `.codex/state/history.md`.
6. Create/update `.codex/meta/initialized.flag` with the current date/time.
7. Exit BOOTSTRAP and wait for the next user task.

---

## 1) NORMAL Mode (Every Task)

### 1.5) Memory-Active UI Indicator (Every Response)

You MUST display a status indicator at the top of every assistant response:

- If running BOOTSTRAP after the user said "start":
  - Prefix the response with: `[Codex Memory: Bootstrapping]`
- Else if `.codex/meta/initialized.flag` exists AND required memory files are readable:
  - Prefix the response with: `[Codex Memory: Active]`
- Else:
  - Prefix the response with: `[Codex Memory: Inactive]`

Rules:
- The indicator must be the **first text** in the response (first line).
- Do not wrap it in markdown code fences.
- Do not include additional status text on that line.

### Always read (in this order)
1. `.codex/meta/project-mode.md`
2. `.codex/brief.md`
3. `.codex/meta/mutation-guards.md`
4. `.codex/meta/skill-trigger-spec.md`
5. `.codex/meta/design-workflow.md`
6. `.codex/memory/*` (including `capabilities.md`)
7. `.codex/state/active-task.md` (if present)

### Always write (end of task)
1. Update `.codex/state/active-task.md` (short: intent → actions → results → next)
2. Append a summary entry to `.codex/state/history.md`
3. Update memory ONLY when allowed by `meta/mutation-guards.md`

---

## 2) Required Scaffold (Create if Missing)

.codex/
  agents.md
  brief.md
  README.md

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md   (generated; do not hand-edit)

.codex/state/
  active-task.md
  history.md

.codex/meta/
  initialized.flag
  project-mode.md
  mutation-guards.md
  skill-trigger-spec.md
  design-workflow.md
  tools.md

Notes:
- `capabilities.md` is generated from skill discovery; regenerate instead of editing.
- `decisions.md` and `history.md` are append-only (see guards).

---

## 3) Memory Initialization from brief.md (BOOTSTRAP)

Read `.codex/brief.md` and generate:

- `.codex/memory/project.md`
- `.codex/memory/architecture.md`
- `.codex/memory/constraints.md`
- `.codex/memory/patterns.md`
- `.codex/memory/decisions.md`
- `.codex/memory/glossary.md`

Rules:
- If unknown, mark as **TBD**. Do not invent.
- Inferred patterns MUST be **PROVISIONAL** + cite evidence (file paths).

---

## 4) Skill Discovery → capabilities.md (BOOTSTRAP + Whenever Skills Change)

Scan both:
1. Global installed skills: `~/.codex/skills/` (example: `/Users/user/.codex/skills`)
2. Repo-local skills (optional): `.codex/skills/`

Generate `.codex/memory/capabilities.md` as a catalog of:
- name, purpose (1 line), triggers, typical inputs/outputs

Do not copy skill internals into memory.

---

## 5) Mode Rules (Phase Gates)

Mode is stored in `.codex/meta/project-mode.md`.

### 5.0) Mode meanings
- `design-first`: NEW project. Default gate: front-end prototype first (HTML-only) + motion-first design.
- `existing`: Existing repo. Ask user if they want a design review before coding changes.
- `memory-only`: Skip design gates. Use memory bank for consistency/coordination only.

Detailed behavior is defined in `.codex/meta/design-workflow.md` and must be followed.

---

## 6) Skill Trigger Heuristics (Deterministic Selection)

Use `.codex/meta/skill-trigger-spec.md`.

If multiple skills match:
1. Most specific trigger match
2. Closest output type
3. Lower-risk first (analysis/design before write-heavy)

Log invoked skills in `.codex/state/active-task.md`.

---

## 7) Memory Mutation Guards

All mutation rules are in `.codex/meta/mutation-guards.md`. Obey strictly.

---

## 8) Tools / MCP / Background Terminals

Document stable tool contracts in `.codex/meta/tools.md`.

---

END
