# Codex Memory Kit v2 — Modes + Design Gate + Local Memory

This kit gives Codex a repo-local “memory bank” under `.codex/`, with:
- A control plane (`.codex/agents.md`)
- A project brief (`.codex/brief.md`)
- Structured memory (`.codex/memory/`)
- Deterministic skill triggers
- Mutation guards (no rewriting history)
- A visible UI indicator: `[Codex Memory: Active]`
- A project mode prompt on first `start`:
  - `design-first` (new project, motion-first HTML prototype gate)
  - `existing` (ask for design review)
  - `memory-only` (skip design gates)

Everything is local markdown. Everything can be committed to git.

---

## Install
1. Copy the `.codex/` folder into the root of your repo.
2. Commit (recommended):
   ```bash
   git add .codex && git commit -m "Add Codex Memory Kit v2"
   ```

---

## Use
1. Edit `.codex/brief.md` (tell the truth about the project).
2. In Codex, type: `start`

On first start, Codex will ask you to choose a mode:
- `design-first`
- `existing`
- `memory-only`

Reply with one word. Codex writes it to `.codex/meta/project-mode.md` and continues.

---

## Design-first workflow (high level)
- HTML-first prototype only (no backend) until “UI Approved” is logged in `memory/decisions.md`.
- Motion-first philosophy (with reduced-motion support).
- Uses `frontend-design` + Chrome MCP + Motion MCP by default.

See `.codex/meta/design-workflow.md` for details.

---

## UI status indicator
Codex should prefix every response with:
- `[Codex Memory: Bootstrapping]` during `start`
- `[Codex Memory: Active]` after initialization
- `[Codex Memory: Inactive]` if not initialized

---

## License
Choose a license (MIT/Apache/proprietary). Unlicensed by default.

END
