# AGENTS.md — Codex Memory Kit v2.6 (Root Contract)

This repository uses **Codex Memory Kit**. Treat this file as the **primary control plane**.

## Non-negotiables
- `.codex/` is **memory/meta/state only**. Do **not** place project source code (app files, node packages, build outputs) inside `.codex/`.
- Keep `.codex/` mostly **markdown** (`.md`) plus a few scripts (`.sh`). Artifacts go in `.codex/artifacts/`.
- Always maintain an audit trail: append-only history + decision logs.
- Prefer implicit/automatic skill use when tasks match skill descriptions.

> Codex Agent Skills support **implicit invocation** (Codex may decide to use a skill automatically when it matches). citeturn1view0

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

---

## STARTUP: when user says "start"
Enter **BOOTSTRAP**.

### Step 0 — Ensure git hygiene (MUST happen first)
Create or update the repo root `.gitignore` by adding (or keeping) a **Codex Memory Kit block**:
- ignore non-doc artifacts under `.codex/`
- ignore any accidental `.js/.ts/.json/.lock` created under `.codex/`
- ignore `.codex/artifacts/` and `.codex/meta/*.flag`
- DO NOT ignore `.codex/**/*.md` or `.codex/scripts/*.sh`

Write the block exactly as documented in:
- `.codex/meta/gitignore-policy.md`

Log the change under:
- `.codex/state/history.md` → **Gitignore Updates**

### Step 1 — Spec source selection (deterministic)
1) Read `.codex/meta/spec-detection.md`.
2) If repo contains `.specify/` → **Spec Kit is canonical**.
   - Read `.codex/meta/spec-sources.md`.
   - If `active_feature_spec` is unset, choose most recently modified `.specify/specs/**/spec.md`.
   - If none exist, ask user which spec folder to target and STOP.
3) If `.specify/` is absent → `brief.md` (repo root) is canonical.
4) Append an audit line to `.codex/state/history.md` under **Spec Source Changes**.

### Step 2 — Mode selection (first run only)
If `.codex/meta/project-mode.md` is unset:
1) Show the **Mode Menu** below (always).
2) Ask user to choose ONE option.
3) Save to `.codex/meta/project-mode.md` and log under **Mode Changes**.
4) STOP (next `start` continues).

#### Mode Menu (always show)
**If NEW project (greenfield):**
1) `design-first` — motion-first HTML prototype, no backend until UI approval
2) `yolo` — design-first, then full build/tests/screenshot/docs when ready
3) `memory-only` — skip design gating entirely

**If EXISTING project:**
1) `existing` — ask once if user wants a design review first
2) `memory-only`

### Step 3 — Bootstrap (mode already set)
1) Ensure `.codex/` scaffold exists.
2) Initialize memory from canonical spec source:
   - Spec Kit: constitution + active spec (+ optional plan/tasks)
   - else: `brief.md`
3) Discover skills and generate `.codex/memory/capabilities.md`.
4) Apply mode workflow rules (`.codex/meta/design-workflow.md`).
5) Append boot entry to `.codex/state/history.md` under **Entries**.
6) Write `.codex/meta/initialized.flag` with date/time.
7) Enter task execution.

---

## Skills, tools, MCP
### Skills
- Prefer **implicit invocation**: when a task matches a skill description, use it without user prompting. citeturn1view0
- If Codex does not implicitly invoke, then explicitly invoke the relevant skill in the response and proceed.

### MCP tools
- If MCP servers are configured, use them when useful.
- If you are in a mode that requires UI output (design-first/yolo), prefer:
  - Chrome MCP for preview + screenshots
  - Motion MCP for animation/motion notes

### About slash commands
Slash commands are user-facing interactive controls in Codex CLI/IDE (e.g. `/mcp`, `/skills`, `/approvals`). citeturn1view2  
Recommend them when visibility is needed, but do not assume you can self-execute slash commands.

### Approval mode note (IDE/VS Code)
To run commands and edits automatically, Codex generally needs to be in an **Agent**-style approval mode. citeturn1view1

---

## Memory rules (do not rewrite history)
Follow `.codex/meta/mutation-guards.md` and `.codex/meta/memory-locks.md` strictly.

END
