# Codex Memory Kit — Detailed Guide (v2.6.8)

This version adds:
- **Checkpoint cooldown** (avoid commit spam)
- **Branch-per-session** (keep experiments off `main`)
…and updates all docs accordingly.

---

## 1) Enable Git Checkpoints (optional)
Default is OFF.

### Auto-commit
Create:
- `.codex/meta/git-autosave.enabled.flag` with `ENABLED`

### Auto-push
Create:
- `.codex/meta/git-autopush.enabled.flag` with `ENABLED`

### Branch-per-session (recommended)
Create:
- `.codex/meta/git-branch-per-session.enabled.flag` with `ENABLED`

What happens:
- On first checkpoint while on `main`/`master`, a branch like
  `codex/<YYYYMMDD-HHMM>-<shortid>` is created and checked out.

### Cooldown (commit frequency cap)
Default: **10 minutes**.

Override:
- `.codex/meta/git-checkpoint.cooldown-minutes.flag` (integer minutes)
- `0` disables cooldown

To bypass:
- `.codex/scripts/git-checkpoint.sh --force "checkpoint: <reason>"`

---

## 2) Recommended checkpoint moments
- After bootstrap
- After spec generation
- After UI approval
- After YOLO verification passes
- Before risky refactors/migrations

Codex should call the checkpoint script at those moments.

---

## 3) Docs + policies
See:
- `.codex/meta/git-checkpoints.md`
- `.codex/meta/frontend-design-checklist.md`
- `.codex/meta/docs-policy.md`

END
