#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
FLAG="$ROOT/.codex/state/tests-passed.flag"
SS_DIR="$ROOT/.codex/artifacts/screenshots"

ok=1

if [[ ! -f "$FLAG" ]]; then
  echo "FAIL: missing .codex/state/tests-passed.flag"
  ok=0
else
  if grep -qx "PASSED" "$FLAG"; then
    echo "OK: tests flag contains PASSED"
  else
    echo "FAIL: tests flag must contain exactly: PASSED"
    ok=0
  fi
fi

if [[ ! -d "$SS_DIR" ]]; then
  echo "FAIL: missing screenshots dir .codex/artifacts/screenshots/"
  ok=0
else
  shopt -s nullglob
  files=("$SS_DIR"/*)
  if [[ ${#files[@]} -eq 0 ]]; then
    echo "FAIL: no screenshots found in .codex/artifacts/screenshots/"
    ok=0
  else
    echo "OK: screenshot(s) found (${#files[@]})"
  fi
fi

if [[ "$ok" -eq 1 ]]; then
  echo "SUCCESS: YOLO verification passed."
  exit 0
else
  echo "FAIL: YOLO verification failed."
  exit 1
fi
