#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
CAP="$ROOT/.codex/memory/capabilities.md"
GLOBAL="${HOME}/.codex/skills"
REPO="$ROOT/.codex/skills"

desc_from_file() {
  local f="$1"
  [[ -f "$f" ]] || return 1
  awk 'NF && $1 !~ /^#/' "$f" | head -n 1
}

write_skill() {
  local dir="$1"
  local name desc
  name="$(basename "$dir")"
  desc=""
  if [[ -f "$dir/skill.md" ]]; then
    desc="$(desc_from_file "$dir/skill.md" || true)"
  elif [[ -f "$dir/README.md" ]]; then
    desc="$(desc_from_file "$dir/README.md" || true)"
  fi
  if [[ -n "$desc" ]]; then
    echo "- $name — $desc"
  else
    echo "- $name"
  fi
}

tmp="$(mktemp)"
{
  echo "# Available Capabilities (Generated)"
  echo ""
  echo "Generated by \`refresh-skills.sh\`. Do not hand-edit."
  echo ""
  echo "## Skills (discovered)"
} > "$tmp"

scan() {
  local dir="$1"
  [[ -d "$dir" ]] || return 0
  for s in "$dir"/*; do
    [[ -d "$s" ]] || continue
    write_skill "$s" >> "$tmp"
  done
}

scan "$REPO"
scan "$GLOBAL"
echo "" >> "$tmp"
echo "END" >> "$tmp"
mv "$tmp" "$CAP"
echo "Wrote $CAP"
