# Git Checkpoints (Auto-save for vibe coding) — v2.6.8

Goal: safe restore points so you can revert when Codex goes off the rails.

---

## Enable (default OFF)

### Auto-commit
Create:
- `.codex/meta/git-autosave.enabled.flag` with exactly: `ENABLED`

### Auto-push (optional)
Create:
- `.codex/meta/git-autopush.enabled.flag` with exactly: `ENABLED`

Push only happens if `origin` exists; if push fails, the local commit still exists.

---

## NEW: Checkpoint cooldown (commit frequency cap)

Default cooldown is **10 minutes**.

Override by creating:
- `.codex/meta/git-checkpoint.cooldown-minutes.flag` containing an integer number of minutes.

Examples:
- `0` → no cooldown (commit every time)
- `10` → commit at most once every 10 minutes (default)

The script stores last checkpoint time in:
- `.codex/meta/git-checkpoint.last.flag` (epoch seconds)

To bypass cooldown for a risky change, call:
- `.codex/scripts/git-checkpoint.sh --force "checkpoint: risky change"`

---

## NEW: Branch-per-session (recommended)

Purpose: keep YOLO runs + large experiments off `main`.

Enable by creating:
- `.codex/meta/git-branch-per-session.enabled.flag` with exactly: `ENABLED`

Behavior:
- On first checkpoint in a session, if you are on `main` or `master`,
  the script will create and checkout a new branch:
  - `codex/<YYYYMMDD-HHMM>-<shortid>`
- It records the chosen branch in:
  - `.codex/meta/git-session-branch.flag`
- Autopush (if enabled) will push that branch and set upstream.

Notes:
- If you're already on a feature branch, it will not force-switch.
- If you want to restart a session branch, delete `.codex/meta/git-session-branch.flag`.

---

## When Codex should checkpoint

Recommended events:
- After `start` bootstrap completes (post lint + gitignore)
- After `spec` completes
- After UI approval
- After YOLO verification passes (tests + screenshot)
- Before risky operations (migrations, dependency bumps, sweeping edits)

Manual:
- `.codex/scripts/git-checkpoint.sh "checkpoint: <reason>"`

END
