# Codex Memory Kit — Detailed Guide (v2.6.7)

This version adds **Git Checkpoints** (auto-save via git commit, optional push).

---

## 0) Canonical docs pointer
Start at `CURRENT.md`.

---

## 1) Enable Git Checkpoints (optional but recommended)
Default is OFF.

### Turn on auto-commit
Create:
- `.codex/meta/git-autosave.enabled.flag` with contents: `ENABLED`

### Turn on auto-push
Create:
- `.codex/meta/git-autopush.enabled.flag` with contents: `ENABLED`

Then Codex should call:
- `.codex/scripts/git-checkpoint.sh "checkpoint: <reason>"`

at key moments (bootstrap, spec generated, UI approved, yolo verified).

---

## 2) Hardened flag semantics
- UI approved flag must contain `APPROVED`
- Tests passed flag must contain `PASSED`

This prevents “empty file = true” mistakes.

---

## 3) Everything else
See:
- `.codex/meta/git-checkpoints.md`
- `.codex/meta/yolo-harness.md`
- `.codex/meta/frontend-design-checklist.md`
- `.codex/meta/docs-policy.md`

END
