#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
FLAG="$ROOT/.codex/meta/ui-approved.flag"
HIST="$ROOT/.codex/state/history.md"
NOTE="${1:-UI approved}"

mkdir -p "$(dirname "$FLAG")" "$(dirname "$HIST")"

date_iso="$(date -Is)"
echo "APPROVED" > "$FLAG"

# Ensure section exists
if ! grep -q "^## UI Approvals" "$HIST" 2>/dev/null; then
  cat >> "$HIST" <<'EOF'

## UI Approvals
- (none)

EOF
fi

# If placeholder exists, remove it once
python3 - "$HIST" <<'PY'
import pathlib, re, sys
p = pathlib.Path(sys.argv[1])
t = p.read_text(encoding="utf-8") if p.exists() else ""
t2 = re.sub(r"(## UI Approvals\s*\n)- \(none\)\s*\n", r"\1", t, count=1)
p.write_text(t2, encoding="utf-8")
PY

echo "- $date_iso — $NOTE" >> "$HIST"
echo "UI approved. Wrote: .codex/meta/ui-approved.flag (APPROVED)"
