# Git Checkpoints (Auto-save for vibe coding)

Goal: create safe restore points so you can revert if Codex goes off the rails.

## What it does
A checkpoint can:
- `git add -A`
- `git commit -m "<message>"`
- optionally `git push` (only if enabled AND a remote exists)

## Safety gates (default: OFF)
To enable auto-commit:
- create `.codex/meta/git-autosave.enabled.flag` containing `ENABLED`

To enable auto-push:
- create `.codex/meta/git-autopush.enabled.flag` containing `ENABLED`

Without these flags, the script will **not** commit/push.

## When Codex should checkpoint
Recommended events:
- After `start` bootstrap completes (post lint + gitignore)
- After `spec` completes (spec files generated)
- After UI approval
- After any "big refactor" or dependency change
- After YOLO verification passes (tests + screenshot)
- Before any risky operation (migrations, sweeping edits)

## Manual use
- `.codex/scripts/git-checkpoint.sh "checkpoint: <reason>"`

## Notes
- Requires that you're already authenticated for git pushes (as you said you are).
- If push fails, commit still exists locally.

END
