// Lightweight motion + mobile menu toggle (prototype only)
const btn = document.querySelector('.hamburger');
const links = document.querySelector('.nav-links');
if (btn && links) {
  btn.addEventListener('click', () => {
    const open = links.style.display === 'flex';
    links.style.display = open ? 'none' : 'flex';
    links.style.flexDirection = 'column';
    links.style.gap = '12px';
    links.style.padding = '12px 0';
    btn.setAttribute('aria-expanded', String(!open));
  });
}

// Simple reveal
const cards = document.querySelectorAll('.card');
cards.forEach((c, i) => {
  c.style.opacity = 0;
  c.style.transform = 'translateY(10px)';
  setTimeout(() => {
    c.style.transition = 'opacity 400ms ease, transform 400ms ease';
    c.style.opacity = 1;
    c.style.transform = 'translateY(0)';
  }, 120 + i * 80);
});
