#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
OUT="$ROOT/dist"
mkdir -p "$OUT"

# Very small include system:
# Replace <!--@include path="..."> with file contents.
render() {
  local in="$1"
  local out="$2"
  python3 - "$in" "$out" <<'PY'
import re, sys, pathlib
inp, outp = sys.argv[1], sys.argv[2]
root = pathlib.Path(inp).parent
txt = pathlib.Path(inp).read_text(encoding="utf-8")
pat = re.compile(r'<!--@include\s+path="([^"]+)"\s*-->')
def repl(m):
    p = (root / m.group(1)).resolve()
    return p.read_text(encoding="utf-8")
txt = pat.sub(repl, txt)
pathlib.Path(outp).write_text(txt, encoding="utf-8")
PY
}

for f in "$ROOT/pages"/*.html; do
  bn="$(basename "$f")"
  render "$f" "$OUT/$bn"
  echo "Built: dist/$bn"
done

echo "Done. Open dist/index.html"
