# Codex Memory Kit — Detailed Guide (v2.6.6)

This version adds quality upgrades to reduce drift:
- Strict `.codex` linter (no non-md outside artifacts)
- Skill descriptions (optional metadata)
- Frictionless UI approval (one flag + one log entry)
- YOLO verification harness (tests flag + screenshot check)
- Canonical docs pointer (`CURRENT.md`)
- Web front-end checklist defaults (hamburger + footer + shared components)
- Copy source-of-truth map + docs policy

---

## 0) Canonical docs entrypoint
Always start at:
- `CURRENT.md` → points to `GUIDE.md`

---

## 1) File placement (the big rule)
Repo root (tracked): `AGENTS.md`, `brief.md`, `MASTER_SPEC.md`, `CURRENT.md`, `GUIDE.md`  
`.codex/` (tracked docs/scripts only): memory/meta/state/scripts  
`.codex/artifacts/` (ignored): screenshots/images

---

## 2) Lint (stop `.codex` from becoming a dumpster)
Run:
- `.codex/scripts/codex-lint.sh`
Fix:
- `.codex/scripts/codex-lint.sh --fix`

Policy is in:
- `.codex/meta/codex-lint-policy.md`

---

## 3) Web projects: design-first checklist defaults
If the project is a site/web app and mode is `design-first` or `yolo`, enforce:
- hamburger menu on mobile
- designed, consistent footer
- shared components to prevent drift

Checklist:
- `.codex/meta/frontend-design-checklist.md`

---

## 4) Spec YOLO
Fill `MASTER_SPEC.md`, then run `spec`.

Slug derives from the “Project name” section (fallback: folder name; override `PROJECT_SLUG`).

Script:
- `.codex/scripts/spec-from-master.sh`

---

## 5) Skills (with optional descriptions)
Refresh:
- `.codex/scripts/refresh-skills.sh`

Optional metadata:
- `.codex/meta/skill-discovery-metadata.md`

---

## 6) UI approval
Approve:
- `.codex/scripts/ui-approve.sh "note"`

Doc:
- `.codex/meta/ui-approval.md`

---

## 7) YOLO verification harness
Standard outputs:
- `.codex/state/tests-passed.flag`
- `.codex/artifacts/screenshots/complete.png`

Verify:
- `.codex/scripts/yolo-verify.sh`

Doc:
- `.codex/meta/yolo-harness.md`

---

## 8) Docs + copy drift prevention
Docs policy:
- `.codex/meta/docs-policy.md`

Copy map template (optional):
- `copy/MAP.md`

END
