# AGENTS.md — Codex Memory Kit v2.6.6

**Canonical control-plane files live at repo root:**
- `AGENTS.md` (this file)
- `brief.md`
- Optional: `MASTER_SPEC.md` (Spec YOLO input)

`.codex/` is memory/meta/state only.

---

## Always-on rules
- Never put app/source code into `.codex/` (except ignored artifacts).
- Keep history append-only.
- Unknowns must be `TBD` or `[ASSUMPTION]` (with rationale).

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

---

## STARTUP ("start")
### Step 0 — Git hygiene + lint
1) Ensure root `.gitignore` contains the kit block from `.codex/meta/gitignore-policy.md`
2) Run `.codex/scripts/codex-lint.sh` (and `--fix` if needed)

### Step 1 — Mode selection (first run)
If `.codex/meta/project-mode.md` is unset, show menu and save selection.

Modes:
- **design-first** (NEW): motion-first HTML prototype, no backend until UI approved
- **yolo** (NEW): design-first then full build/tests/screenshot/docs
- **existing**: ask once if user wants a design review first
- **memory-only**: skip design gating

### Step 2 — Web project design checklist
If the project is a website/web app AND mode is `design-first` or `yolo`:
- follow `.codex/meta/frontend-design-checklist.md`
- Required defaults unless user opts out:
  - mobile hamburger menu
  - consistent, designed footer across pages
  - shared components (nav/footer/buttons/cards)

### Step 3 — Skills + MCP
Before non-trivial work:
- read `.codex/memory/capabilities.md`
- invoke best skill(s)
- use MCP servers when relevant (Chrome preview/screenshot, Motion animations)

### Step 4 — Spec YOLO ("spec")
If user says `spec` and `MASTER_SPEC.md` exists:
- run `.codex/scripts/spec-from-master.sh`
- do not ask questions
- quarantine unknowns as `[ASSUMPTION]` or `TBD`

### Step 5 — UI approval
To mark design approved:
- run `.codex/scripts/ui-approve.sh "note"`

### Step 6 — YOLO verification
In `yolo` mode, completion requires:
- `.codex/state/tests-passed.flag`
- screenshot in `.codex/artifacts/screenshots/`
- `.codex/scripts/yolo-verify.sh` returns success

END
