#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
FLAG="$ROOT/.codex/meta/ui-approved.flag"
HIST="$ROOT/.codex/state/history.md"
NOTE="${1:-UI approved}"

mkdir -p "$(dirname "$FLAG")" "$(dirname "$HIST")"

date_iso="$(date -Is)"
echo "" > "$FLAG"

# Append under UI Approvals (create section if missing)
if ! grep -q "^## UI Approvals" "$HIST" 2>/dev/null; then
  cat >> "$HIST" <<'EOF'

## UI Approvals
- (none)

EOF
fi

# Replace placeholder "(none)" once
perl -0777 -i -pe 's/## UI Approvals\s*\n- \(none\)\s*\n/## UI Approvals\n/ if $.==1' "$HIST" 2>/dev/null || true

# Append entry
{
  echo "- $date_iso — $NOTE"
} >> "$HIST"

echo "UI approved. Flag created: .codex/meta/ui-approved.flag"
echo "Logged in: .codex/state/history.md"
