# Front-End Design Checklist (Web projects)

Use this for **design-first** and **yolo** modes unless the user explicitly opts out.

## IA & Navigation
- Mobile has a **hamburger menu** (easy to reach, clear label/icon).
- Navigation states exist: default / hover / active / focus.
- One clear primary CTA in the header or hero.

## Footer (required for sites + web apps)
- Footer is present and consistent across pages.
- Includes: product/site name, primary links, support/contact, legal links (as needed).
- Looks intentional (spacing, hierarchy, not a dump).

## Components (anti-drift)
- Shared components exist (at minimum): nav + footer + buttons + cards.
- Components are reused across pages, not re-invented.

## Layout & Responsiveness
- Mobile → tablet → desktop breakpoints tested.
- Reasonable line length and spacing.
- Accessible touch targets on mobile.

## Motion (motion-first philosophy)
- Motion is used to clarify hierarchy and interactions, not just decoration.
- Micro-interactions: nav open/close, button press, section reveal.
- Reduced-motion considerations (at least: avoid nausea-level movement).

## Quality gates
- Lighthouse-ish basics: readable contrast, keyboard focus visible.
- No obvious CLS (layout shift) during load.
- Prototype is runnable locally with a single command.

END
