# Codex Lint Policy (No Non-MD in .codex)

Purpose: stop git noise + “helpful” tools from dumping runtime files into `.codex/`.

## Allowed file types in `.codex/` (outside `.codex/artifacts/`)
- `.md`
- `.sh`
- `.flag`
- `.keep`

Everything else is considered a violation.

## Exception
`.codex/artifacts/**` may contain anything, but that directory is ignored by git.

## Fix guidance
If a disallowed file appears in `.codex/`:
1) Move it to `.codex/artifacts/misc/`
2) Ensure `.gitignore` has the kit block
3) Remove it from git if tracked (`git rm --cached ...`)

Run: `.codex/scripts/codex-lint.sh --fix`

END
