# Codex Memory Kit — Detailed Guide (v2.6.5)

This guide explains how to install and use Codex Memory Kit with:
- Root canon (`AGENTS.md`, `brief.md`)
- Repo-local memory in `.codex/`
- Optional Spec Kit integration (pluggable)
- Spec YOLO using a single root `MASTER_SPEC.md` (no Q&A)

---

## What goes where (critical)

### Repo root (tracked)
- `AGENTS.md` — the contract Codex should follow
- `brief.md` — canonical brief when Spec Kit is absent
- `MASTER_SPEC.md` — single-source input for Spec YOLO (recommended)
- `.gitignore` — must include the “CODEX MEMORY KIT” block
- `GUIDE.md` — this manual

### `.codex/` (tracked: docs + scripts only)
- `.codex/meta/` — policies + flags
- `.codex/memory/` — decision log + capability index
- `.codex/state/` — run reports + task history
- `.codex/scripts/` — helper scripts

### `.codex/artifacts/` (NOT tracked)
Screenshots/images/build artifacts. `.keep` files exist only to preserve folders.

---

## Install
1) Copy `.codex/` into repo root
2) Add root `AGENTS.md`, `brief.md`, and `MASTER_SPEC.md`
3) Ensure `.gitignore` contains the kit block
4) Commit

---

## Spec YOLO (one file → spec/plan/tasks)
1) Fill out `MASTER_SPEC.md`
2) In Codex: `spec` (or run `.codex/scripts/spec-from-master.sh`)

Outputs:
- `.specify/specs/<project-slug>/spec.md`
- `.specify/specs/<project-slug>/plan.md`
- `.specify/specs/<project-slug>/tasks.md`

### Slug selection (v2.6.5)
- Uses the first non-empty line after `## 1) Project name`
- Slugifies it (lowercase, spaces → dashes, strips symbols)
- Fallback: repo folder name
- Override: `PROJECT_SLUG=<slug>`

---

## Assumption quarantine (anti-hallucination)
Unknowns must be:
- `TBD`, or
- `[ASSUMPTION]` with rationale

Assumptions must be appended to `.codex/memory/decisions.md`.

END
