# AGENTS.md — Codex Memory Kit v2.6.5 (Root-Only + Spec Kit Bootstrap + Master Spec YOLO)

This repository uses **Codex Memory Kit**.

**Canonical control-plane files live at repo root:**
- `AGENTS.md` (this file)
- `brief.md`

Optional input file (recommended for Spec YOLO):
- `MASTER_SPEC.md` (single source input)

`.codex/` is reserved for **memory/meta/state only**.

---

## Non-negotiables
- Do **not** place project source code inside `.codex/`.
- Keep `.codex/` mostly Markdown plus a few scripts.
- Always maintain an audit trail: append-only history + decisions.
- Do not rewrite history; update via append-only logs.
- Unknowns must be `TBD` or tagged `[ASSUMPTION]` (never silent invention).

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

If the indicator disappears, treat it as drift and restore it immediately.

---

## STARTUP: when user says "start"
Enter **BOOTSTRAP**.

### Step 0 — Git hygiene (MUST happen first)
Ensure root `.gitignore` contains the exact **Codex Memory Kit block** defined in:
- `.codex/meta/gitignore-policy.md`

If forbidden `.codex/` files are already tracked by git:
- `git rm -r --cached .codex && git add .codex` (or equivalent)
- append to `.codex/state/history.md` under **Gitignore Updates**

### Step 1 — Mode selection (first run only)
If `.codex/meta/project-mode.md` is unset:
1) Show the **Mode Menu** below.
2) Ask user to choose ONE.
3) Save to `.codex/meta/project-mode.md` and log under **Mode Changes**.
4) STOP (next `start` continues).

#### Mode Menu
**If NEW project:**
1) `design-first` — motion-first HTML prototype in `prototype/`, no backend until UI approval
2) `yolo` — design-first then full build/tests/screenshot/docs when ready
3) `memory-only` — skip design gating

**If EXISTING project:**
1) `existing` — ask once if user wants a design review first
2) `memory-only`

### Step 2 — Optional Spec Kit bootstrap (NEW projects)
Offer bootstrap when:
- mode is `design-first` or `yolo`
- `.specify/` is NOT present
- `specify` CLI exists on PATH

If offered:
1) Ask: **Initialize Spec Kit here? (Yes/No)**
2) If Yes:
   - run `.codex/scripts/spec-kit-init.sh` (default: `specify init --here --ai codex`)
   - re-run Step 0 (git hygiene)
   - log under **Spec Kit Bootstrap**
3) If No:
   - proceed with root `brief.md` as canonical

### Step 2b — Master Spec YOLO (no more questions)
If user says `spec` OR explicitly wants **Spec YOLO** AND `MASTER_SPEC.md` exists:
- Run `.codex/scripts/spec-from-master.sh`
- Do NOT ask for more input
- Any unknowns must be recorded as `[ASSUMPTION]` (with rationale) or left `TBD`

---

## SPEC COMMAND: when user says "spec"
Purpose: generate Spec Kit files from `MASTER_SPEC.md` with **zero extra user input**.

Notes:
- Project slug defaults to a slugified version of the value under **“## 1) Project name”** in `MASTER_SPEC.md`.
- Fallback if missing/blank: repo folder name.
- Override: `PROJECT_SLUG` environment variable.

Rules:
- Do not ask clarifying questions.
- Fill gaps via inference only if safe; tag as `[ASSUMPTION]`.
- Otherwise use `TBD`.

END
