#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
CAP="$ROOT/.codex/memory/capabilities.md"
GLOBAL="${HOME}/.codex/skills"
REPO="$ROOT/.codex/skills"

tmp="$(mktemp)"
{
  echo "# Available Capabilities (Generated)"
  echo ""
  echo "## Skills (discovered)"
} > "$tmp"

scan() {
  local dir="$1"
  [[ -d "$dir" ]] || return 0
  for s in "$dir"/*; do
    [[ -d "$s" ]] || continue
    echo "- $(basename "$s")" >> "$tmp"
  done
}

scan "$REPO"
scan "$GLOBAL"
echo "" >> "$tmp"
echo "END" >> "$tmp"
mv "$tmp" "$CAP"
echo "Wrote $CAP"
