# MASTER_SPEC — Single Source Input (Template)

This file is designed for **Spec YOLO**: a “one doc → full spec/plan/tasks” workflow.

Write as much detail as you can. The goal is: **no follow-up questions**.

---

## 1) Project name
MemoryKit (Codex Memory Kit)

## 2) One-liner
Repo-local memory + workflow rules for Codex. Ship fast without rewriting history.

## 3) Problem / why
- Context drift between sessions
- “Helpful rewrites” of decisions/constraints
- Repo noise (random generated files)
- Inconsistent tool/skill usage

## 4) Solution
- Root control-plane: AGENTS.md + brief.md
- Local memory in .codex/
- Modes (design-first / yolo / existing / memory-only)
- Mutation guards + optional locks
- Skill + MCP heuristics
- Optional autonomous loops

## 5) Target audience
- Codex CLI + VS Code users
- teams shipping lots of repos
- indie hackers

## 6) Marketing site copy
(put your final copy here: hero, sections, FAQ, CTAs)

## 7) Product requirements
- Required behaviors
- Non-goals
- Constraints

## 8) Acceptance criteria
What counts as DONE (tests, screenshot, docs, etc.)

## 9) Unknowns allowed
List what Codex is allowed to assume vs must stay TBD.

END
