#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
REPORT="$ROOT/.codex/state/doctor-report.md"

agents_status="$([[ -f "$ROOT/AGENTS.md" ]] && echo ok || echo missing)"
brief_status="$([[ -f "$ROOT/brief.md" ]] && echo ok || echo missing)"
master_status="$([[ -f "$ROOT/MASTER_SPEC.md" ]] && echo present || echo absent)"
speckit_status="$([[ -d "$ROOT/.specify" ]] && echo present || echo absent)"
specify_status="missing"
command -v specify >/dev/null 2>&1 && specify_status="ok"

{
  echo "# Memory Doctor Report"
  echo ""
  echo "- Date: $(date -Is)"
  echo "- Root AGENTS.md: $agents_status"
  echo "- Root brief.md: $brief_status"
  echo "- Root MASTER_SPEC.md: $master_status"
  echo "- .specify/: $speckit_status"
  echo "- specify CLI: $specify_status"
} > "$REPORT"

echo "Wrote $REPORT"
