# Master Spec YOLO Policy — v2.6.3
*Last updated:* 2025-12-30

## Goal
Enable a “Spec Kit YOLO” workflow:
- You maintain a single root input file: `MASTER_SPEC.md`
- Running `spec` generates Spec Kit files without needing extra user input
- Any missing info is handled via **assumption quarantine**

## Assumption quarantine (mandatory)
If something is unknown:
- Either keep it as `TBD`, or
- Fill it in as `[ASSUMPTION]` with rationale, or
- Provide `[OPTION A] / [OPTION B]` and choose a default (with rationale)

All assumptions must be written to:
- `.specify/specs/<project>/spec.md` (Assumptions section)
- `.codex/memory/decisions.md` (append-only)

## What gets generated
`spec-from-master.sh` produces (or refreshes):
- `.specify/memory/constitution.md` (if missing)
- `.specify/specs/<project>/spec.md`
- `.specify/specs/<project>/plan.md`
- `.specify/specs/<project>/tasks.md`
And writes a run report:
- `.codex/state/spec-run-report.md`

## No-more-questions guarantee
When running Spec YOLO:
- do not ask user for clarifications
- proceed with labeled assumptions
- keep everything auditable
