# AGENTS.md — Codex Memory Kit v2.6.2 (Root-Only + Spec Kit Bootstrap)

This repository uses **Codex Memory Kit**.

**Canonical control-plane files live at repo root:**
- `AGENTS.md` (this file)
- `brief.md`

`.codex/` is reserved for **memory/meta/state only**.

---

## Non-negotiables
- Do **not** place project source code inside `.codex/`.
- Keep `.codex/` mostly Markdown plus a few scripts.
- Always maintain an audit trail: append-only history + decisions.
- Do not rewrite history; update via append-only logs.

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

If the indicator disappears, treat it as drift and restore it immediately.

---

## STARTUP: when user says "start"
Enter **BOOTSTRAP**.

### Step 0 — Git hygiene (MUST happen first)
Create/update root `.gitignore` by adding (or keeping) the exact **Codex Memory Kit block** defined in:
- `.codex/meta/gitignore-policy.md`

If forbidden `.codex/` files are already tracked by git:
- `git rm -r --cached .codex && git add .codex` (or equivalent)
- append to `.codex/state/history.md` under **Gitignore Updates**

### Step 1 — Mode selection (first run only)
If `.codex/meta/project-mode.md` is unset:
1) Show the **Mode Menu** below.
2) Ask user to choose ONE.
3) Save to `.codex/meta/project-mode.md` and log under **Mode Changes**.
4) STOP (next `start` continues).

#### Mode Menu
**If NEW project:**
1) `design-first` — motion-first HTML prototype in `prototype/`, no backend until UI approval
2) `yolo` — design-first then full build/tests/screenshot/docs when ready
3) `memory-only` — skip design gating

**If EXISTING project:**
1) `existing` — ask once if user wants a design review first
2) `memory-only`

### Step 2 — Optional Spec Kit bootstrap (NEW projects)
Pluggable integration: Spec Kit remains external, but MemoryKit can bootstrap it.

Offer bootstrap when:
- mode is `design-first` or `yolo`
- `.specify/` is NOT present
- `specify` CLI exists on PATH

If offered:
1) Ask: **Initialize Spec Kit here? (Yes/No)**
2) If Yes:
   - run `.codex/scripts/spec-kit-init.sh` (default: `specify init --here --ai codex`)
   - re-run Step 0 (git hygiene)
   - log under **Spec Kit Bootstrap**
3) If No:
   - proceed with root `brief.md` as canonical

### Step 3 — Canonical spec source selection
Read `.codex/meta/spec-detection.md`.

- If `.specify/` exists → Spec Kit is canonical (use `.codex/meta/spec-sources.md`)
- Else → root `brief.md` is canonical

Log under **Spec Source Changes**.

### Step 4 — Bootstrap
- ensure `.codex/` scaffold
- initialize memory from canonical spec source
- discover skills → `.codex/memory/capabilities.md` (run `refresh-skills.sh`)
- apply mode workflow rules (`.codex/meta/design-workflow.md`)
- write `.codex/meta/initialized.flag`
- enter task execution

---

## Skill trigger heuristics
Before non-trivial work, do a **Skill Scan**:
1) read `.codex/memory/capabilities.md`
2) select best skill(s)
3) state `Invoking skill: <name>` and proceed

Triggers:
- `frontend-design` → UI, layout, prototype, responsive, accessibility
- `canvas-design` → motion notes, interaction states, animation spec
- `theme-factory` → tokens, colors, typography, design system
- `webapp-testing` → tests/e2e/smoke checks
- `doc-coauthoring` → README/runbooks/docs
- `algorithmic-art` → generative visuals/patterns
- `skill-creator` → creating/updating skills/triggers

MCP:
- Chrome MCP → preview/verify UI + screenshots
- Motion MCP → animations/transitions/micro-interactions

---

## Autonomous Loops (optional)
See `.codex/meta/autonomous-loops.md` for an “iterate until checks pass (or capped)” harness pattern.

END
