#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"

if ! command -v specify >/dev/null 2>&1; then
  echo "ERROR: 'specify' CLI not found on PATH."
  echo "Install: uv tool install specify-cli --from git+https://github.com/github/spec-kit.git"
  exit 1
fi

cd "$ROOT"

AI="${1:-codex}"
FORCE="${FORCE:-0}"
IGNORE_AGENT_TOOLS="${IGNORE_AGENT_TOOLS:-0}"
DEBUG="${DEBUG:-0}"

args=(init --here --ai "$AI")
[[ "$FORCE" == "1" ]] && args+=(--force)
[[ "$IGNORE_AGENT_TOOLS" == "1" ]] && args+=(--ignore-agent-tools)
[[ "$DEBUG" == "1" ]] && args+=(--debug)

echo "Running: specify ${args[*]}"
specify "${args[@]}"
