# AGENTS.md — Codex Memory Kit v2.6.1 (Root-Only)

This repository uses **Codex Memory Kit**.

**Canonical control-plane files live at repo root:**
- `AGENTS.md` (this file)
- `brief.md`

`.codex/` is reserved for **memory/meta/state only**.

---

## Non‑negotiables
- Do **not** place project source code (app files, node packages, build outputs) inside `.codex/`.
- Keep `.codex/` mostly **Markdown** (`.md`) plus a few scripts (`.sh`).
- Always maintain an audit trail: append-only history + decision logs.
- Do not “helpfully” rewrite history; update via append-only logs.

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

If the indicator disappears, treat it as drift and restore it immediately.

---

## STARTUP: when user says "start"
Enter **BOOTSTRAP**.

### Step 0 — Git hygiene (MUST happen first)
Create or update the repo root `.gitignore` by adding (or keeping) the exact **Codex Memory Kit block** defined in:
- `.codex/meta/gitignore-policy.md`

If forbidden `.codex/` files are already tracked by git:
- remove them from index (keep on disk) and document it:
  - `git rm -r --cached .codex && git add .codex` (or equivalent)
- append to `.codex/state/history.md` under **Gitignore Updates**

### Step 1 — Canonical spec source selection
Read `.codex/meta/spec-detection.md`.

1) If repo contains `.specify/` → **Spec Kit is canonical**.
   - Use `.codex/meta/spec-sources.md` to pick the active spec.
2) If `.specify/` is absent → **root `brief.md` is canonical**.

Append a line to `.codex/state/history.md` under **Spec Source Changes**.

### Step 2 — Mode selection (first run only)
If `.codex/meta/project-mode.md` is unset:
1) Show the **Mode Menu** below (always).
2) Ask user to choose ONE option.
3) Save to `.codex/meta/project-mode.md` and log under **Mode Changes**.
4) STOP (next `start` continues).

#### Mode Menu (always show)
**If NEW project (greenfield):**
1) `design-first` — motion-first HTML prototype in `prototype/`, no backend until UI approval
2) `yolo` — design-first then full build/tests/screenshot/docs when ready
3) `memory-only` — skip design gating entirely

**If EXISTING project:**
1) `existing` — ask once if user wants a design review first
2) `memory-only`

### Step 3 — Bootstrap (mode already set)
1) Ensure `.codex/` scaffold exists.
2) Initialize memory from canonical spec source:
   - Spec Kit: constitution + active spec (+ optional plan/tasks)
   - else: root `brief.md`
3) Discover skills and generate `.codex/memory/capabilities.md` (run `.codex/scripts/refresh-skills.sh`).
4) Apply mode workflow rules (`.codex/meta/design-workflow.md`).
5) Append boot entry to `.codex/state/history.md` under **Entries**.
6) Write `.codex/meta/initialized.flag` with date/time.
7) Enter task execution.

---

## Skill trigger heuristics (so you don’t have to babysit)
Before starting any non-trivial task, do a **Skill Scan**:
1) read `.codex/memory/capabilities.md`
2) choose best skill(s) based on the triggers below
3) explicitly state: `Invoking skill: <name>` and proceed

### Built-in triggers for your installed skills
- `frontend-design` → UI, landing pages, layout, components, prototype, responsive, accessibility
- `canvas-design` → motion notes, interaction states, animation spec, UI polish, “Figma-style” spec
- `theme-factory` → design systems, tokens, colors, typography, component theming
- `webapp-testing` → tests, Playwright/e2e, regression, “prove it works”
- `doc-coauthoring` → README/RUNBOOK, docs, onboarding, handoff guides
- `algorithmic-art` → generative visuals, procedural graphics, patterns
- `skill-creator` → creating/updating skills, triggers, or skill docs

### MCP trigger heuristics
- Chrome MCP → any time UI must be verified, previewed, or screenshot
- Motion MCP → any time animation, motion-first behavior, transitions are required

If tools/skills still aren’t being invoked automatically in Agent mode:
- treat that as a matching/trigger problem
- tighten triggers (keywords + task patterns) and retry

---

## Autonomous Loops (optional feature)
See `.codex/meta/autonomous-loops.md` for a Ralph-Wiggum-style “iterate until done” harness pattern.
Use only when you have clear, programmatic success checks (tests pass, build succeeds, screenshot captured).

END
