#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
REPORT="$ROOT/.codex/state/doctor-report.md"
MODE="$ROOT/.codex/meta/project-mode.md"
LOCKS="$ROOT/.codex/meta/memory-locks.md"
GITIGNORE="$ROOT/.gitignore"

ROOT_AGENTS="$ROOT/AGENTS.md"
ROOT_BRIEF="$ROOT/brief.md"

mode="unset"
if [[ -f "$MODE" ]]; then
  mode="$(grep -E '^Current:' "$MODE" | sed 's/^Current:[[:space:]]*//' || true)"
  [[ -z "$mode" ]] && mode="unset"
fi

lock_count=0
if [[ -f "$LOCKS" ]]; then
  lines="$(grep -E '^[[:space:]]*-[[:space:]]*(FILE|SECTION):' "$LOCKS" || true)"
  [[ -n "$lines" ]] && lock_count="$(echo "$lines" | wc -l | tr -d ' ')"
fi

gitignore_status="missing"
if [[ -f "$GITIGNORE" ]]; then
  if grep -q "CODEX MEMORY KIT (BEGIN)" "$GITIGNORE"; then
    gitignore_status="has-kit-block"
  else
    gitignore_status="missing-kit-block"
  fi
fi

agents_status="$([[ -f "$ROOT_AGENTS" ]] && echo ok || echo missing)"
brief_status="$([[ -f "$ROOT_BRIEF" ]] && echo ok || echo missing)"

{
  echo "# Memory Doctor Report"
  echo ""
  echo "- Date: $(date -Is)"
  echo "- Root AGENTS.md: $agents_status"
  echo "- Root brief.md: $brief_status"
  echo "- Mode: $mode"
  echo "- Locks: $lock_count"
  echo "- .gitignore: $gitignore_status"
} > "$REPORT"

echo "Wrote $REPORT"
