# Autonomous Loops (Ralph‑Wiggum‑style) — v0.1

This is an **optional** harness pattern inspired by the “Ralph Wiggum” autonomous loop concept:
- Run the same task prompt repeatedly
- Each iteration sees the modified files and git history from previous runs
- Stop only when completion criteria are met or iteration budget is exhausted

Use this ONLY when you have **hard verification**:
- tests pass
- build succeeds
- lint passes
- screenshot captured

## Loop contract (what Codex should do)
Set:
- `max_iterations` (default 10)
- `success_checks` (commands + expected outcomes)
- `checkpoint_policy` (git commit every N iterations or at milestones)

Loop:
1) Plan micro-steps
2) Execute
3) Verify (run success checks)
4) If fail: summarize failures → adjust → iterate
5) If pass: stop and document

Safety:
- Always cap iterations.
- Always produce an audit line per iteration in `.codex/state/history.md`.

END
