# Codex Memory Kit — Full Current Guide (v2.6.10)

This document is the **single, current guide** for Codex Memory Kit.  
It is also written to be **usable as an About page** (you can lift sections directly).

---

## About: what this is

Codex Memory Kit is a **repo-local memory + workflow contract** for Codex (and Codex-in-VS-Code workflows).  
It gives you two things that vibe coding normally lacks:

1) **Stable ground**: a place where decisions, status, and constraints live, locally, in your repo.
2) **Guardrails**: rules that stop the model from “helpfully” rewriting history, re-breaking fixed parts, or spraying random files into memory.

Everything is designed to be:
- **Local-first** (stored under `.codex/` in your repo)
- **Auditable** (append-only logs)
- **Revertible** (git checkpoints)
- **Composable** (skills + tools + MCP servers)

---

## Why it exists (the short story)

Without an explicit memory contract, models tend to:
- forget or overwrite prior decisions,
- reintroduce old bugs while fixing new ones,
- generate “memory” as a pile of random files (often JS/node junk),
- and drift UI/components over time.

Memory Kit solves this by treating your project like a living system with:
- a **control plane** (`AGENTS.md`, `brief.md`, optional `MASTER_SPEC.md`)
- a **memory bank** (`.codex/memory/`, `.codex/state/`, `.codex/meta/`)
- and explicit policies: **mutation guards**, **component locks**, **git checkpoints**, **design-first gating**.

---

## What’s in the box (feature overview)

### 1) Local memory bank (`.codex/`)
- **meta**: policies, mode settings, lock registry, flags
- **memory**: durable capabilities + decisions
- **state**: session history, active task, spec run report
- **artifacts**: screenshots/images/misc (always ignored by git)

### 2) Modes (startup menu)
On `start`, Codex chooses (and saves) a mode:
- **design-first**: build a motion-first HTML prototype; no backend until UI is approved
- **yolo**: design-first, then complete build + tests + screenshot + docs
- **existing**: for established projects; ask if user wants design review first
- **memory-only**: skip design gating; use memory/tools directly

### 3) Spec YOLO (one doc → spec/plan/tasks)
If `MASTER_SPEC.md` exists, `spec` generates Spec Kit outputs **without questions**.  
Unknowns must be either `TBD` or `[ASSUMPTION]` with rationale.

### 4) Skill discovery (installed skills)
Skills can live in:
- global: `~/.codex/skills`
- repo: `.codex/skills`

Memory Kit includes a discovery script that writes a generated list:
- `.codex/memory/capabilities.md`

### 5) Git checkpoints (“autosave for vibe coding”)
Optional auto-commit, optional auto-push, optional branch-per-session, and a cooldown to prevent spam.

### 6) Component locks (permission-to-edit)
When you move on, Codex should ask: **“Are we done? Lock it?”**  
Locked targets require explicit permission before Codex edits them again.

---

## Installation

### Files that must be at repo root
- `AGENTS.md` (the contract)
- `brief.md` (project brief; used when Spec Kit is absent)
- `CURRENT.md` (canonical pointer)
- `GUIDE.md` (this guide)

Recommended:
- `MASTER_SPEC.md` (Spec YOLO input)

### Folder that must be at repo root
- `.codex/` (memory bank)

### `.gitignore` requirement
Your repo root `.gitignore` must include the Memory Kit block from:
- `.codex/meta/gitignore-policy.md`

This prevents accidental tracking of `.codex/` artifacts and any noisy generated files.

---

## Daily use

### 1) Start
In Codex: run `start`

Codex must:
1) ensure `.gitignore` has the block
2) run `.codex/scripts/codex-lint.sh` (move disallowed files to artifacts if `--fix`)
3) run `.codex/scripts/refresh-skills.sh`
4) show the mode menu if unset and save it into `.codex/meta/project-mode.md`
5) (optional) checkpoint after bootstrap

### 2) Work normally
As you work, Codex must:
- maintain append-only logs in `.codex/state/history.md`
- avoid writing non-doc files into `.codex/` (outside `.codex/artifacts/`)
- use skills/tools/MCP when appropriate (no user prompting required)

### 3) Lock components when you shift focus
When you say “next”, or you clearly move to another part:
- Codex must ask if the previous component is “done”
- if yes, Codex locks it (SOFT by default)

Lock command:
- `.codex/scripts/lock-component.sh SOFT <path-or-glob> "note"`

Before editing a locked target:
- `.codex/scripts/is-locked.sh <path>`
- if locked, Codex must ask permission

Unlock:
- `.codex/scripts/unlock-component.sh --i-acknowledge <LOCK_ID>`

---

## Modes in detail

### design-first
Goal: fast, visual truth before backend complexity.
Rules:
- build a prototype in a `prototype/` folder (or equivalent)
- prioritize motion, layout, UX, component consistency
- no backend/DB/auth until UI approval

### yolo
Goal: ship a full working project from specs with minimal back-and-forth.
Rules:
- still design-first
- once UI is “good enough”, Codex may continue autonomously
Completion must include:
- tests flagged PASSED (`.codex/state/tests-passed.flag`)
- at least one screenshot in `.codex/artifacts/screenshots/`
- docs updated
- optional: yolo verification script succeeds (`.codex/scripts/yolo-verify.sh`)

### existing
Goal: avoid breaking a working codebase.
Rules:
- ask once if user wants a design review pass first
- recommend relevant skills/tools/MCP combinations

### memory-only
Goal: use memory + guardrails without forcing design gates.
Rules:
- skip design-first requirements
- keep mutation guards + locks + git checkpoints active

---

## Git checkpoints (optional, recommended)

Enable autosave commits:
- `.codex/meta/git-autosave.enabled.flag` = `ENABLED`

Optional autopush:
- `.codex/meta/git-autopush.enabled.flag` = `ENABLED`

Optional branch-per-session:
- `.codex/meta/git-branch-per-session.enabled.flag` = `ENABLED`

Cooldown (default 10 minutes):
- `.codex/meta/git-checkpoint.cooldown-minutes.flag` = integer
- `0` disables cooldown
Force a checkpoint:
- `.codex/scripts/git-checkpoint.sh --force "checkpoint: risky change"`

Why branch-per-session matters:
- YOLO runs and refactors can be chaotic; keeping them off `main` makes rollback trivial.

---

## Skill discovery (how it’s used)

Run:
- `.codex/scripts/refresh-skills.sh`

It scans:
- `.codex/skills/` (repo)
- `~/.codex/skills` (global)

Then writes a generated list to:
- `.codex/memory/capabilities.md`

Codex should use this list to pick the right skill automatically.

Optional: add `skill.md` inside a skill folder for better descriptions.

---

## Quality rules that matter

### No non-doc files in `.codex/`
Allowed: `.md`, `.sh`, `.flag`, `.keep`  
Everything else must go to `.codex/artifacts/`.

Lint:
- `.codex/scripts/codex-lint.sh`
Auto-fix:
- `.codex/scripts/codex-lint.sh --fix`

### Mutation guards (no rewriting history)
- `.codex/memory/decisions.md` and `.codex/state/history.md` are append-only
- if something changes, add a new entry with date + reason

### Component consistency
For web projects (design-first/yolo), default expectations include:
- mobile hamburger nav
- consistent footer across pages
- shared components to prevent drift
See:
- `.codex/meta/frontend-design-checklist.md`

---

## What this kit can’t do (honest limitations)

- It cannot enforce locks at the OS/editor level by itself.
- It works because **Codex is instructed to follow the contract**.
- If you want “hard enforcement,” the next step is a repo hook (pre-commit/pre-push) that blocks changes to locked paths unless explicitly overridden.

---

## Troubleshooting

### “Codex wrote a bunch of junk into .codex”
Run:
- `.codex/scripts/codex-lint.sh --fix`
Then ensure `.gitignore` has the kit block.

### “Codex ignored my locks”
Check:
- `.codex/meta/locks/` contains the lock file
- Codex is running `is-locked.sh` before editing
If not, that’s a contract violation; point it back to `AGENTS.md`.

### “No skills are showing up”
Run:
- `.codex/scripts/refresh-skills.sh`
Confirm skills exist in:
- `~/.codex/skills` and/or `.codex/skills`

### “Git autosave didn’t commit”
Verify:
- you are inside a git repo
- `.codex/meta/git-autosave.enabled.flag` contains exactly `ENABLED`
- there were actual changes to commit
- cooldown didn’t skip it (use `--force`)

---

## Appendix: file map

### Root
- `AGENTS.md` — contract
- `brief.md` — brief source when Spec Kit absent
- `MASTER_SPEC.md` — Spec YOLO input (optional)
- `GUIDE.md` — full guide (this)
- `CURRENT.md` — canonical pointer

### .codex/
- `meta/` — policies, flags, locks, mode
- `memory/` — capabilities + decisions
- `state/` — history + reports
- `scripts/` — lint, skill scan, locks, git checkpoints
- `artifacts/` — screenshots/images/misc (ignored)

END
