# AGENTS.md — Codex Memory Kit v2.6.10 (Clean)

Canonical control-plane files live at repo root:
- `AGENTS.md` (this file)
- `brief.md`
- Optional: `MASTER_SPEC.md` (Spec YOLO input)

`.codex/` is memory/meta/state only.

---

## Always-on rules
- Never put app/source code into `.codex/` (except ignored artifacts).
- Keep history append-only.
- Unknowns must be `TBD` or `[ASSUMPTION]` (with rationale).

---

## Session UI Indicator (every response)
Start every response with:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)> | Git: <autosave-on|off>/<autopush-on|off>/<branch-session-on|off> | Cooldown: <min>]`

Cooldown is derived from `.codex/meta/git-checkpoint.cooldown-minutes.flag` (default 10).

---

## Component Locking (anti-regression)
### Core behavior
- When user shifts focus to a new component/task, ask:
  “Are we done with <component>? Lock it so we don’t change it without permission?”
- If user says yes:
  - create a lock via `.codex/scripts/lock-component.sh SOFT <path-or-glob> "note"`
- Before editing any file or directory:
  - run `.codex/scripts/is-locked.sh <path>`
  - if locked, ask permission to proceed
  - if approved, log approval and checkpoint before/after the edit

### Lock defaults
- Default lock level: SOFT
- Use HARD only if user requests “hard lock”

---

## STARTUP ("start")
### Step 0 — Git hygiene + lint
1) Ensure root `.gitignore` contains kit block from `.codex/meta/gitignore-policy.md`
2) Run `.codex/scripts/codex-lint.sh` (and `--fix` if needed)
3) Refresh skills:
   - `.codex/scripts/refresh-skills.sh`
4) Git checkpoint (if enabled):
   - `.codex/scripts/git-checkpoint.sh "checkpoint: bootstrap complete"`

### Step 1 — Mode selection (first run)
If `.codex/meta/project-mode.md` is unset, show menu and save selection.

Modes:
- design-first: motion-first HTML prototype; no backend until UI approved
- yolo: design-first then full build/tests/screenshot/docs
- existing: ask once if user wants a design review first
- memory-only: skip design gating

### Step 2 — Web project checklist defaults
If the project is a website/web app AND mode is design-first or yolo:
- follow `.codex/meta/frontend-design-checklist.md`
Defaults unless user opts out:
- mobile hamburger menu
- consistent, designed footer across pages
- shared components (nav/footer/buttons/cards)

### Step 3 — Spec YOLO ("spec")
If user says `spec` and `MASTER_SPEC.md` exists:
- run `.codex/scripts/spec-from-master.sh`
- do not ask questions
- quarantine unknowns as `[ASSUMPTION]` or `TBD`
- checkpoint:
  - `.codex/scripts/git-checkpoint.sh "checkpoint: spec generated"`

### Step 4 — UI approval
Approve:
- `.codex/scripts/ui-approve.sh "note"`
Then checkpoint:
- `.codex/scripts/git-checkpoint.sh "checkpoint: UI approved"`

### Step 5 — YOLO verification
Completion requires:
- `.codex/state/tests-passed.flag` contains `PASSED`
- screenshot exists in `.codex/artifacts/screenshots/`
- `.codex/scripts/yolo-verify.sh` returns success
Then checkpoint:
- `.codex/scripts/git-checkpoint.sh "checkpoint: yolo verified"`

END
