#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
LOCKS_DIR="$ROOT/.codex/meta/locks"
HIST="$ROOT/.codex/state/history.md"

if [[ "${1:-}" != "--i-acknowledge" ]]; then
  echo "Usage: unlock-component.sh --i-acknowledge <LOCK_ID> [note]"
  exit 2
fi
shift
LOCK_ID="${1:-}"
shift || true
NOTE="${1:-}"

if [[ -z "$LOCK_ID" ]]; then
  echo "ERROR: missing LOCK_ID"
  exit 2
fi

lock_file="$LOCKS_DIR/${LOCK_ID}.lock"
if [[ ! -f "$lock_file" ]]; then
  echo "ERROR: lock not found: $LOCK_ID"
  exit 1
fi

rm -f "$lock_file"

mkdir -p "$(dirname "$HIST")"
if ! grep -q "^## Lock Events" "$HIST" 2>/dev/null; then
  cat >> "$HIST" <<'EOF'

## Lock Events
- (none)

EOF
fi
python3 - "$HIST" <<'PY'
import pathlib, re, sys
p = pathlib.Path(sys.argv[1])
t = p.read_text(encoding="utf-8") if p.exists() else ""
t2 = re.sub(r"(## Lock Events\s*\n)- \(none\)\s*\n", r"\1", t, count=1)
p.write_text(t2, encoding="utf-8")
PY
echo "- $(date -Is) — UNLOCKED — $LOCK_ID — ${NOTE:-}" >> "$HIST"

echo "Unlocked: $LOCK_ID"
