#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
LOCKS_DIR="$ROOT/.codex/meta/locks"

TARGET="${1:-}"
if [[ -z "$TARGET" ]]; then
  echo "Usage: is-locked.sh <path>"
  exit 2
fi

target="$TARGET"

if [[ ! -d "$LOCKS_DIR" ]]; then
  echo "OK: no locks"
  exit 0
fi

is_glob() {
  [[ "$1" == *"*"* || "$1" == *"?"* || "$1" == *"["* ]]
}

matches() {
  local rule="$1" path="$2"
  if is_glob "$rule"; then
    [[ "$path" == $rule ]]
  else
    [[ "$path" == "$rule" || "$path" == "$rule/"* ]]
  fi
}

for f in "$LOCKS_DIR"/*.lock; do
  [[ -f "$f" ]] || continue
  # shellcheck disable=SC1090
  source "$f"
  if matches "$TARGET" "$target"; then
    echo "LOCKED: $ID ($LEVEL) matches $target"
    exit 1
  fi
done

echo "OK: not locked"
exit 0
