#!/usr/bin/env bash
set -euo pipefail

ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
CODEX="$ROOT/.codex"
FIX="${1:-}"

[[ -d "$CODEX" ]] || { echo "OK: .codex missing."; exit 0; }

allowed_re='(\.md$|\.sh$|\.flag$|/\.keep$)'
violations=()

while IFS= read -r -d '' f; do
  [[ -f "$f" ]] || continue
  [[ "$f" == "$CODEX/artifacts/"* ]] && continue
  if [[ ! "$f" =~ $allowed_re ]]; then
    violations+=("$f")
  fi
done < <(find "$CODEX" -type f -print0)

if [[ ${#violations[@]} -eq 0 ]]; then
  echo "OK: .codex lint passed."
  exit 0
fi

echo "FAIL: disallowed files in .codex (outside artifacts):"
for v in "${violations[@]}"; do
  echo " - ${v#$ROOT/}"
done

if [[ "$FIX" == "--fix" ]]; then
  mkdir -p "$CODEX/artifacts/misc"
  for v in "${violations[@]}"; do
    bn="$(basename "$v")"
    mv -f "$v" "$CODEX/artifacts/misc/$bn"
    echo "Moved: ${v#$ROOT/} -> .codex/artifacts/misc/$bn"
  done
  echo "Fix complete."
  exit 0
fi

exit 1
