# Git Checkpoints (Auto-save for vibe coding) — v2.6.10

Goal: safe restore points so you can revert when Codex goes off the rails.

## Enable (default OFF)
Auto-commit:
- `.codex/meta/git-autosave.enabled.flag` with exactly: `ENABLED`

Auto-push (optional):
- `.codex/meta/git-autopush.enabled.flag` with exactly: `ENABLED`

## Checkpoint cooldown (commit frequency cap)
Default: 10 minutes

Override:
- `.codex/meta/git-checkpoint.cooldown-minutes.flag` (integer minutes)
- `0` disables cooldown

Bypass:
- `.codex/scripts/git-checkpoint.sh --force "checkpoint: risky change"`

State:
- `.codex/meta/git-checkpoint.last.flag` (epoch seconds)

## Branch-per-session (recommended)
Enable:
- `.codex/meta/git-branch-per-session.enabled.flag` with `ENABLED`

Behavior:
- If on `main`/`master`, first checkpoint creates/checkouts:
  `codex/<YYYYMMDD-HHMM>-<shortid>`
- Records:
  - `.codex/meta/git-session-branch.flag`

END
