# Front-End Design Checklist (Web projects)

Use this for **design-first** and **yolo** modes unless the user explicitly opts out.

## IA & Navigation
- Mobile has a **hamburger menu** (easy to reach, clear label/icon).
- Navigation states exist: default / hover / active / focus.
- One clear primary CTA in the header or hero.

## Footer (required for sites + web apps)
- Footer is present and consistent across pages.
- Includes: product/site name, primary links, support/contact, legal links (as needed).
- Looks intentional.

## Components (anti-drift)
- Shared components exist (at minimum): nav + footer + buttons + cards.
- Components are reused across pages.

## Motion (motion-first philosophy)
- Motion clarifies hierarchy and interactions.
- Micro-interactions: nav open/close, button press, section reveal.
- Avoid nausea-level movement by default.

END
