#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
CAP="$ROOT/.codex/memory/capabilities.md"
GLOBAL_SKILLS="${HOME}/.codex/skills"
LOCAL_SKILLS="$ROOT/.codex/skills"

tmp="$(mktemp)"
{
  echo "# Available Capabilities (Generated)"
  echo "> File: \`.codex/memory/capabilities.md\`"
  echo ""
  echo "## Skills (discovered)"
} > "$tmp"

add_skill_dir() {
  local dir="$1"
  [[ -d "$dir" ]] || return 0
  for s in "$dir"/*; do
    [[ -d "$s" ]] || continue
    echo "- $(basename "$s")" >> "$tmp"
  done
}
add_skill_dir "$GLOBAL_SKILLS"
add_skill_dir "$LOCAL_SKILLS"

echo "" >> "$tmp"
echo "END" >> "$tmp"
mv "$tmp" "$CAP"
echo "Wrote $CAP"
