#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
REPORT="$ROOT/.codex/state/doctor-report.md"
SPECDIR="$ROOT/.specify"
CONSTITUTION="$ROOT/.specify/memory/constitution.md"

spec_present="no"
spec_health="n/a"
if [[ -d "$SPECDIR" ]]; then
  spec_present="yes"
  [[ -f "$CONSTITUTION" ]] && spec_health="ok" || spec_health="missing-constitution"
fi

{
  echo "# Memory Doctor Report"
  echo ""
  echo "## Summary"
  echo "- Date: $(date -Is)"
  echo "- Spec Kit present: $spec_present"
  echo "- Spec Kit health: $spec_health"
} > "$REPORT"

echo "Wrote $REPORT"
