# Spec Source Detection & Precedence
> File: `.codex/meta/spec-detection.md`

## Precedence (highest → lowest)
1) **Spec Kit** (if repository contains `.specify/`)
   Canonical sources:
   - `.specify/memory/constitution.md`
   - `.specify/specs/**/spec.md`
   - (optional) `.specify/specs/**/plan.md`
   - (optional) `.specify/specs/**/tasks.md`

   If Spec Kit is canonical:
   - `.codex/brief.md` is treated as an index/pointer only.
   - Codex memory may store distilled summaries, but must cite source paths in change logs.

2) **Codex Memory Kit** (if `.specify/` is absent AND `.codex/agents.md` + `.codex/brief.md` exist)
   Canonical sources:
   - `.codex/agents.md`
   - `.codex/brief.md`
   - `.codex/memory/*`

3) **No spec system present**
   - Codex creates `.codex/` scaffold and prompts the user.

## Detection rules
- Spec Kit is present if a `.specify/` directory exists at repo root.
- If `.specify/` exists but canonical files are missing, Codex should warn and recommend running `specify`.

## Recording
Whenever Codex chooses a spec source, append to:
- `.codex/state/history.md` under **Spec Source Changes**

END
