# YOLO Mode Runbook
> File: `.codex/meta/yolo-runbook.md`

YOLO is for **new projects** (no real app yet). It can build a complete project end-to-end from the canonical spec source.

## Canonical spec source
- If `.specify/` exists → Spec Kit is canonical.
- Else → `.codex/brief.md` is canonical.

## NEW project heuristic
Treat as NEW if MOST are true:
- No `package.json`, `pyproject.toml`, `go.mod`, `Cargo.toml`, etc.
- No existing app framework directory (`src/`, `app/`, etc.)
- No existing test runner config
- Repo contains mainly `.codex/` and/or `.specify/` (plus maybe README)

If not clearly NEW:
- recommend `existing` mode (or `memory-only`).

## Definition of Done (non-negotiable)
1) App runs (dev server or local build)
2) Tests pass (at least smoke tests; prefer unit + e2e)
3) Screenshot saved to `.codex/artifacts/screenshots/` (Chrome MCP preferred)
4) Documentation updated:
   - repo README
   - RUNBOOK: run/test/build steps

## Allowed power tools (use when available)
- MCP: Chrome (validate UI + produce screenshots)
- MCP: Motion (animation workflows)
- Web research + public-page scraping (respect robots/ToS; no auth/private)
- Image generation (e.g., Nano Banana Pro) → `.codex/artifacts/images/`
- Installed Codex skills: frontend-design, theme-factory, webapp-testing, doc-coauthoring, etc.

END
