# Spec Source Detection & Precedence
> File: `.codex/meta/spec-detection.md`

## Precedence (highest → lowest)
1) **Spec Kit** if repo contains `.specify/`
   Canonical sources:
   - `.specify/memory/constitution.md`
   - `.specify/specs/**/spec.md`
   - optional: `.specify/specs/**/plan.md`
   - optional: `.specify/specs/**/tasks.md`

   If Spec Kit is canonical:
   - `.codex/brief.md` is treated as an index/pointer only.
   - Codex may store distilled summaries in `.codex/memory/*`, but must cite source paths in change logs.

2) **Codex Memory Kit** if `.specify/` is absent AND `.codex/agents.md` + `.codex/brief.md` exist
   Canonical sources:
   - `.codex/agents.md`
   - `.codex/brief.md`
   - `.codex/memory/*`

3) **No spec system present**
   - Codex creates `.codex/` scaffold and prompts the user.

## Recording
Whenever Codex selects a canonical spec source, append to:
- `.codex/state/history.md` under **Spec Source Changes**

END
