# Memory Mutation Guards
> File: `.codex/meta/mutation-guards.md`

These rules prevent “helpful” history rewrites.

## Golden rules
- Memory must be auditable.
- Do not rewrite the past; evolve it.
- Locks override everything.

## Append-only (never edit old content)
- `.codex/memory/decisions.md`
- `.codex/state/history.md`

Superseding decisions:
- add a new entry with `Supersedes: D### (YYYY-MM-DD)`.

## Controlled-edit (must not be locked)
- project.md
- architecture.md
- constraints.md
- patterns.md
- glossary.md

Every edit must include:

```
## Change Log
- 2025-12-28: <what changed> — reason: <user instruction or source paths>
```

## Generated (regenerate only)
- capabilities.md (BOOTSTRAP or refresh-skills)

END
