# Design Workflow (Mode Gate)
> File: `.codex/meta/design-workflow.md`

## A) design-first
- Always begin with a motion-first HTML prototype.
- No backend work until UI is approved:
  - Decision entry in `memory/decisions.md`, OR
  - `.codex/meta/ui-approved.flag` exists

## B) yolo
- Same design-first start.
- Codex may auto-approve UI if it meets criteria from canonical spec source:
  - Spec Kit (if present) OR `.codex/brief.md` otherwise.
- On auto-approval:
  - append “UI Auto-Approved (YOLO)” in `memory/decisions.md`
  - write `.codex/meta/ui-approved.flag` with checklist summary
- Then build full project per `meta/yolo-runbook.md`

## C) existing
- Before significant UI changes, ask once:
  “Do you want a design review first? (yes/no)”
- If yes, use frontend-design + Chrome MCP + Motion MCP.

## D) memory-only
- Skip design gates entirely.

END
