# Codex Memory Kit v2.5.1 — Agent Control Plane
> File: `.codex/agents.md`

This file is the **boot + behavior contract** for Codex in this repo:
- local memory bank in `.codex/`
- deterministic skill triggers
- strict mutation guards + memory locks
- modes (design-first / yolo / existing / memory-only)
- Spec Kit integration (if `.specify/` exists)
- UI indicator (memory-active + mode + locks)

---

## 0) Commands (Always Available)

### 0.1) start  (BOOTSTRAP)
When the user says **"start"**, enter **BOOTSTRAP**.

#### Step 0 — Spec source selection (MUST happen first)
1) Read `.codex/meta/spec-detection.md`.
2) If repo contains `.specify/` → Spec Kit is **canonical**.
   - Read `.codex/meta/spec-sources.md`.
   - If `active_feature_spec` is unset, default to the most recently modified `.specify/specs/**/spec.md`.
   - If no spec exists, ask the user which spec folder to target and STOP.
3) If repo does NOT contain `.specify/` → `.codex/brief.md` is **canonical** (if present).
4) Append an audit line to `.codex/state/history.md` under **Spec Source Changes**.

#### Step 1 — Mode selection (first run only)
If `.codex/meta/project-mode.md` does NOT exist:
1) Create scaffold in Section 2 (so files exist).
2) Determine whether this is a **NEW project** (see `.codex/meta/yolo-runbook.md`).
3) If NEW project, prompt the user to choose ONE:
   - `design-first`
   - `yolo`
   - `memory-only`
   If NOT new, prompt for ONE:
   - `existing`
   - `memory-only`
4) Write selection into `.codex/meta/project-mode.md` under `Current:`.
5) Append an audit line to `.codex/state/history.md` under **Mode Changes**.
6) STOP (do not continue BOOTSTRAP until mode is set).

#### Step 2 — Full BOOTSTRAP (mode already set)
If `.codex/meta/project-mode.md` exists:
1) Ensure scaffold exists (Section 2).
2) Initialize memory from the canonical spec source:
   - Spec Kit: constitution + active spec (+ plan/tasks if present)
   - Else: `.codex/brief.md`
3) Discover installed skills and generate `.codex/memory/capabilities.md`.
4) Apply mode rules (`.codex/meta/design-workflow.md`).
5) Append a boot record to `.codex/state/history.md` under **Entries**.
6) Write/update `.codex/meta/initialized.flag` with date/time.
7) If mode is `yolo` AND repo qualifies as a NEW project:
   - Begin YOLO execution per `.codex/meta/yolo-runbook.md`
   - Log phases under **YOLO Runs**
8) Exit BOOTSTRAP.

---

### 0.2) switch-mode: <design-first|yolo|existing|memory-only>
1) Validate requested mode.
2) Update `.codex/meta/project-mode.md`.
3) Append audit entry under **Mode Changes**.

---

### 0.3) refresh-skills
Regenerates `.codex/memory/capabilities.md` by scanning:
- global skills: `~/\.codex/skills/`
- repo skills: `.codex/skills/` (if present)

Append a line under **Skill Refreshes**.

---

### 0.4) memory-doctor
Runs invariant checks and writes `.codex/state/doctor-report.md`.
Append a line under **Diagnostics**.

---

### 0.5) approve-ui: <note>
Creates `.codex/meta/ui-approved.flag` and appends a decision entry to `.codex/memory/decisions.md`.

---

### 0.6) Memory scope locks (v2.3+)
- `lock: memory/<file>.md`
- `lock-section: memory/<file>.md :: <Heading Text>`
- `unlock: memory/<file>.md`
- `unlock-section: memory/<file>.md :: <Heading Text>`
- `unlock-all`

All lock changes MUST be logged under **Lock Changes**.

---

## 1) UI Indicator (Every Response)

The first line of every response MUST be:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

UI rules:
- If mode is `design-first` or `yolo`: UI is `approved` iff `.codex/meta/ui-approved.flag` exists, else `not-approved`
- Otherwise UI = `n/a`

Locks rules:
- Parse `.codex/meta/memory-locks.md` for lines starting with `- FILE:` or `- SECTION:`
- N = count of those lines (excluding “(none)”)

---

## 2) Required Scaffold (Create if Missing)

.codex/
  agents.md
  brief.md
  README.md
  QUICKSTART.md
  CHANGELOG.md
  LICENSE

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md

.codex/state/
  active-task.md
  history.md
  doctor-report.md

.codex/meta/
  initialized.flag
  ui-approved.flag
  project-mode.md
  mutation-guards.md
  memory-locks.md
  skill-trigger-spec.md
  design-workflow.md
  yolo-runbook.md
  tools.md
  spec-detection.md
  spec-sources.md

.codex/artifacts/
  screenshots/
  images/

.codex/scripts/
  refresh-skills.sh
  memory-doctor.sh

marketing/
  index.html
  copy.md

---

## 3) Read / Write Order (Stable)

Always read (in this order):
1. `.codex/meta/spec-detection.md`
2. `.codex/meta/spec-sources.md` (if Spec Kit present)
3. `.codex/meta/project-mode.md`
4. `.codex/meta/design-workflow.md`
5. `.codex/meta/yolo-runbook.md`
6. `.codex/brief.md` (canonical only when Spec Kit absent)
7. `.codex/meta/mutation-guards.md`
8. `.codex/meta/memory-locks.md`
9. `.codex/meta/skill-trigger-spec.md`
10. `.codex/meta/tools.md`
11. `.codex/memory/*` (incl. `capabilities.md`)
12. `.codex/state/active-task.md`
13. `.codex/state/doctor-report.md` (read-only)

Always write (end of task):
1. `.codex/state/active-task.md`
2. `.codex/state/history.md` (append)
3. `.codex/memory/*` only when allowed by guards AND not blocked by locks

---

## 4) Locks enforcement (non-negotiable)

Before editing any `.codex/memory/<file>.md`:
1) Check `.codex/meta/memory-locks.md`.
2) If `FILE: memory/<file>.md` exists → do not edit.
3) If editing within a section and `SECTION: memory/<file>.md :: <Heading Text>` exists → do not edit.

If blocked:
- state which lock blocked it
- provide the exact unlock command

END
