#!/usr/bin/env bash
set -euo pipefail

ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
CAP="$ROOT/.codex/memory/capabilities.md"

GLOBAL_SKILLS="${HOME}/.codex/skills"
LOCAL_SKILLS="$ROOT/.codex/skills"

tmp="$(mktemp)"
{
  echo "# Available Capabilities (Generated)"
  echo "> File: \`.codex/memory/capabilities.md\`"
  echo ""
  echo "Generated by skill discovery (BOOTSTRAP or \`refresh-skills\`). Do not hand-edit."
  echo ""
  echo "## Skills (discovered)"
} > "$tmp"

add_skill_dir() {
  local dir="$1"
  if [[ -d "$dir" ]]; then
    for s in "$dir"/*; do
      [[ -d "$s" ]] || continue
      name="$(basename "$s")"
      hint=""
      if [[ -f "$s/README.md" ]]; then
        hint="$(grep -m1 -E '\S' "$s/README.md" | sed 's/^[# ]*//')"
      fi
      if [[ -n "$hint" ]]; then
        echo "- ${name} — ${hint}" >> "$tmp"
      else
        echo "- ${name}" >> "$tmp"
      fi
    done
  fi
}

add_skill_dir "$GLOBAL_SKILLS"
add_skill_dir "$LOCAL_SKILLS"

echo "" >> "$tmp"
echo "END" >> "$tmp"

mv "$tmp" "$CAP"
echo "Wrote $CAP"
