# YOLO Mode Runbook
> File: `.codex/meta/yolo-runbook.md`

YOLO mode is for **new projects** where the repo is basically empty (no real app yet).
Codex may create a complete, working project **end-to-end** from `.codex/brief.md`.

## Definition of "new project" (heuristic)
Treat as new if MOST of the following are true:
- No `package.json`, `pyproject.toml`, `go.mod`, `Cargo.toml`, etc.
- No `src/` or `app/` directory for an existing framework
- No existing test runner config
- Only `.codex/` (and maybe a top-level README) exists

If it's not clearly new, Codex must suggest switching to `existing` mode.

## Non-negotiable deliverables
YOLO run is done only when:
1. App builds/runs locally (or in dev server).
2. Tests pass (at least smoke tests; ideally unit + e2e).
3. A screenshot exists (store under `.codex/artifacts/screenshots/`).
4. Documentation is present:
   - updated repo README
   - a short RUNBOOK (how to run/test/build)

## Allowed power tools (use when available)
- MCP: Chrome (UI validation + screenshots)
- MCP: Motion (animation prototyping / motion design)
- Web research tool(s): to find references, copy ideas, link sources
- Content scraping: only from permitted pages; respect robots/ToS
- Image generation: e.g., “Nano Banana Pro” or equivalent (create brand assets, hero images)
- Installed Codex skills (frontend-design, theme-factory, webapp-testing, doc-coauthoring, etc.)

## Safety / ethics notes
- Do not scrape private/auth content.
- Cite or link sources in docs if you borrow structure/content.
- Avoid copyrighted assets unless user provides them.

## Output cadence
- Keep an execution plan in `.codex/state/active-task.md`.
- Log major phases in `.codex/state/history.md` under **YOLO Runs**.

END
