# Design Workflow (Mode Gate)
> File: `.codex/meta/design-workflow.md`

This file defines front-end-first behavior and how modes gate work.

## A) Mode: design-first (NEW project default)
Goal: create a fast visual prototype before any backend work.

### Phase 1 — Front-end prototype only
Rules:
- Produce HTML-first UI to represent the product visually.
- Do NOT create backend code, database schemas, APIs, auth, or server logic.
- Prioritize motion-first design (animation communicates hierarchy and state).
- Use:
  - `frontend-design` (primary)
  - `theme-factory` (tokens/palette)
  - `canvas-design` (if canvas visuals are part of the UI)
  - `doc-coauthoring` (UI spec + component map)
  - Chrome MCP server (browser validation)
  - Motion MCP server (animation/graphics workflow)

Required outputs (definition of done):
- Core pages/screens in HTML
- Responsive layout (desktop + mobile)
- Motion rules (where/why animations are used)
- `prefers-reduced-motion` support
- Component inventory (what becomes real components later)

### Exiting Phase 1 (Unlock backend)
Backend work is allowed only after EITHER:
1) A Decision Log entry exists in `.codex/memory/decisions.md` that declares “UI Approved”, OR
2) `.codex/meta/ui-approved.flag` exists (typically set via `approve-ui: <note>`).

Shortcut:
- `approve-ui: <note>`

---

## B) Mode: yolo (NEW project "build it all")
YOLO is **design-first + self-approval + full build**.

Rules:
- Still starts with front-end prototype first (same as design-first).
- Codex may **self-approve** the UI when it meets project criteria and proceed.
- Codex must:
  - record “UI Auto-Approved (YOLO)” in `.codex/memory/decisions.md`
  - write `.codex/meta/ui-approved.flag` with a brief checklist summary
- After approval, Codex proceeds to implement a complete, tested project per `.codex/meta/yolo-runbook.md`.

---

## C) Mode: existing
Before making significant UI changes, ask once:
“Do you want a design review first? (yes/no)”

If yes:
- Run design review using `frontend-design` + Chrome MCP + Motion MCP.
- Optionally combine with: `theme-factory`, `webapp-testing`, `doc-coauthoring`.

---

## D) Mode: memory-only
Skip design gates entirely.
- Do not force prototype-first workflows.
- Use the memory bank + skills normally to complete tasks.

END
