# Codex Memory Kit v2.4 — Agent Control Plane
> File: `.codex/agents.md`

You are **Codex** operating inside this repository. Your job is to complete tasks while using local, versioned context stored under `.codex/`.

This file is the **control plane**: boot behavior, memory usage, skill triggers, mutation guards, commands, and a visible **UI indicator**.

---

## 0) Commands (Always Available)

### 0.1) start  (BOOTSTRAP)
When the user says **"start"**, enter **BOOTSTRAP mode**.

If `.codex/meta/project-mode.md` does NOT exist, you MUST:
1. Create the scaffold in Section 2 (so the files exist).
2. Determine whether this looks like a NEW project (see `.codex/meta/yolo-runbook.md` heuristic).
3. If NEW project, ask the user to choose one mode by replying with exactly one of:
   - `design-first`
   - `yolo`
   - `memory-only`
   If NOT a new project, ask for:
   - `existing`
   - `memory-only`
4. Write the chosen mode to `.codex/meta/project-mode.md` (set `Current:`).
5. Append a mode-selection entry in `.codex/state/history.md` under **Mode Changes**.
6. Stop (do not continue bootstrapping until mode is set).

If `.codex/meta/project-mode.md` exists, continue bootstrapping:
1. Ensure scaffold exists (Section 2).
2. Read `.codex/brief.md` and initialize memory files (Section 3).
3. Discover installed skills and generate `.codex/memory/capabilities.md`.
4. Apply mode rules (`.codex/meta/design-workflow.md`).
5. Write a boot record to `.codex/state/history.md` under **Entries**.
6. Create/update `.codex/meta/initialized.flag` with date/time.
7. If mode is `yolo` AND repo qualifies as a NEW project:
   - Begin YOLO execution immediately per `.codex/meta/yolo-runbook.md`.
   - Keep logs in `.codex/state/history.md` under **YOLO Runs**.
8. Exit BOOTSTRAP.

### 0.2) switch-mode: <design-first|yolo|existing|memory-only>
Update mode and append audit line under **Mode Changes**.

### 0.3) refresh-skills
Rescan skills and regenerate `.codex/memory/capabilities.md`. Log under **Skill Refreshes**.

### 0.4) memory-doctor
Run invariant checks and write `.codex/state/doctor-report.md`. Log under **Diagnostics**.

### 0.5) approve-ui: <note>
Create `.codex/meta/ui-approved.flag` and append decision entry. Log under **Entries**.

### 0.6) Memory scope locks
- `lock: memory/<file>.md`
- `lock-section: memory/<file>.md :: <Heading Text>`
- `unlock: memory/<file>.md`
- `unlock-section: memory/<file>.md :: <Heading Text>`
- `unlock-all`

All lock changes MUST be logged under **Lock Changes**.

---

## 1) UI Indicator (Every Response)

First line must be:

`[Codex Memory: <Bootstrapping|Active|Inactive> | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

UI rules:
- If mode is `design-first` or `yolo`: UI uses `.codex/meta/ui-approved.flag` (approved/not-approved)
- Else: UI = `n/a`

Locks rules:
- Parse `.codex/meta/memory-locks.md` for lines beginning with `- FILE:` or `- SECTION:`.
- N = count of those lines (excluding “(none)”).

---

## 2) Required Scaffold (Create if Missing)

.codex/
  agents.md
  brief.md
  README.md
  QUICKSTART.md
  CHANGELOG.md
  LICENSE

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md

.codex/state/
  active-task.md
  history.md
  doctor-report.md

.codex/meta/
  initialized.flag
  ui-approved.flag
  project-mode.md
  mutation-guards.md
  memory-locks.md
  skill-trigger-spec.md
  design-workflow.md
  yolo-runbook.md
  tools.md

.codex/artifacts/
  screenshots/
  images/

.codex/scripts/
  refresh-skills.sh
  memory-doctor.sh

---

## 3) Read/Write Order (Unchanged, extended)

Always read (in this order):
1. `.codex/meta/project-mode.md`
2. `.codex/meta/design-workflow.md`
3. `.codex/meta/yolo-runbook.md`
4. `.codex/brief.md`
5. `.codex/meta/mutation-guards.md`
6. `.codex/meta/memory-locks.md`
7. `.codex/meta/skill-trigger-spec.md`
8. `.codex/meta/tools.md`
9. `.codex/memory/*`
10. `.codex/state/active-task.md`
11. `.codex/state/doctor-report.md` (read-only)

Always write (end of task):
1. `.codex/state/active-task.md`
2. `.codex/state/history.md` (append)
3. Memory files only if allowed by mutation guards AND not locked.

---

## 4) YOLO execution rules (mode = yolo)

### Phase 0 — Plan
- Create a build plan and stack choice (minimal, sane defaults).
- Use web research only when it materially reduces risk.
- Record plan in `state/active-task.md`.

### Phase 1 — Design-first (same as design-first mode)
- Produce a motion-first HTML prototype.
- Validate in browser (Chrome MCP).
- Define acceptance checklist derived from `.codex/brief.md`.

### Phase 2 — UI Auto-Approval (YOLO)
If the design meets the checklist:
- Append “UI Auto-Approved (YOLO)” to `.codex/memory/decisions.md`.
- Write `.codex/meta/ui-approved.flag` with the checklist summary.

### Phase 3 — Build full project
- Implement the full stack per the brief and prototype.
- Use the skills + MCP servers + available tools.
- Add tests and get them passing (`webapp-testing`).

### Phase 4 — Screenshot + docs
- Produce at least one screenshot in `.codex/artifacts/screenshots/` via Chrome MCP.
- Update repo README + add a short RUNBOOK section (run/test/build).
- Log completion in `state/history.md` under **YOLO Runs**.

If the design does NOT meet the checklist:
- Do not proceed to backend.
- Ask the user what to change (or switch to `design-first`).

END
