# Skill Trigger Spec
> File: `.codex/meta/skill-trigger-spec.md`

Deterministic heuristics for choosing installed skills and meta commands.

## Installed Skills (Known)
- algorithmic-art
- canvas-design
- doc-coauthoring
- frontend-design
- skill-creator
- theme-factory
- webapp-testing

## Meta commands (always available)
- start
- switch-mode: <...>
- refresh-skills
- memory-doctor
- approve-ui: <note>
- lock: memory/<file>.md
- lock-section: memory/<file>.md :: <Heading Text>
- unlock: memory/<file>.md
- unlock-section: memory/<file>.md :: <Heading Text>
- unlock-all

## Global matching rules
Match if:
1) user request contains trigger keywords, OR
2) user request implies output type, OR
3) mode workflow demands it (see `meta/design-workflow.md`)

If multiple match:
1) specific trigger match
2) output-type match
3) lower-risk first (analysis/design before write-heavy)

## Skill triggers (short)

### frontend-design
Triggers: UI, component, layout, responsive, Tailwind/CSS, React/Next, design system, prototype, HTML

### theme-factory
Triggers: theme, palette, tokens, branding, typography, dark mode

### canvas-design
Triggers: canvas, draw, animation loop, particles, requestAnimationFrame, interactive visuals

### algorithmic-art
Triggers: procedural, generative, fractal, noise, shader, parametric, p5.js

### doc-coauthoring
Triggers: docs, README, guide, spec, PRD, RFC, onboarding, runbook, SOP, lead magnet

### webapp-testing
Triggers: test, QA, Playwright, Cypress, Jest/Vitest, coverage, regression, smoke test

### skill-creator
Triggers: new skill, create skill, automate workflow, capability, reusable workflow

END
