# Memory Scope Locks
> File: `.codex/meta/memory-locks.md`

This file lists active locks that prevent edits to specific memory files or specific sections.

## Why locks exist
To prevent “helpful” drift: once something is stable (e.g., constraints), we can lock it so it only changes with explicit user intent.

## How Codex must behave
- If a target is locked, Codex MUST NOT modify it.
- Codex must explain the lock and show the exact unlock command.
- Locks must be visible:
  - UI indicator shows `Locks: ON (N)` when any locks are active
  - `memory-doctor` lists all locks

## Format (machine-friendly)
Use only these list formats (one per line):

### File locks
- `FILE: memory/<name>.md`

### Section locks
- `SECTION: memory/<name>.md :: <Heading Text>`

Example:
- FILE: memory/constraints.md
- SECTION: memory/project.md :: Goals

## Active locks
- (none)

END
